unit PortDeUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ShellAPI;

type
  TForm1 = class(TForm)
    ButtonInfo: TButton;
    ButtonHilfe: TButton;
    Label1: TLabel;
    RadioLPT1: TRadioButton;
    RadioLPT1a: TRadioButton;
    RadioLPT2: TRadioButton;
    RadioCOM1: TRadioButton;
    RadioCOM2: TRadioButton;
    ButtonEIN: TButton;
    ButtonAUS: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    procedure ButtonEINClick(Sender: TObject);
    procedure ButtonAUSClick(Sender: TObject);
    procedure RadioLPT1Click(Sender: TObject);
    procedure RadioLPT1aClick(Sender: TObject);
    procedure RadioLPT2Click(Sender: TObject);
    procedure RadioCOM1Click(Sender: TObject);
    procedure RadioCOM2Click(Sender: TObject);
    procedure ButtonInfoClick(Sender: TObject);
    procedure ButtonHilfeClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;
  gelesen, schreiben: Integer;
  STyp: String[3] = 'LPT';
  BasAdr: Integer = $378;
  ComHandle: THandle;

implementation

{$R *.DFM}

{Funktionen aus "inpout32.dll" laden:}
procedure Out32(Addresse:Integer; Wert:byte);stdcall;export;
external 'INPOUT32.DLL';
function Inp32(Addresse:Integer):Byte;stdcall;export;
external 'INPOUT32.DLL';


procedure TForm1.ButtonEINClick(Sender: TObject);
begin
 if STyp = 'LPT' then
  begin
   {Alle Bits im Daten-Register setzen:}
   Out32(BasAdr, 255);  {alle Datenausgnge high}
   {Um die 4 Steuerausgnge zu setzen, mssen Bit0,
    Bit1, Bit3 gelscht und Bit2 gesetzt werden.
    Auerdem wird Bit4 (Interrupt enable) gesetzt
    und Bit5 (bidirektional) gelscht. Bit6, Bit7
    sind ohne Bedeutung:}
   Out32(BasAdr+2, 20);  {alle Steuerausgnge high}
   {Registerinhalte einlesen und anzeigen:}
   gelesen := Inp32(BasAdr);
   Label3.Caption := 'Parallelport-Daten-Register';
   Label4.Caption := IntToStr(gelesen);
   gelesen := Inp32(BasAdr+2);
   Label5.Caption := 'Parallelport-Steuer-Register';
   Label6.Caption := IntToStr(gelesen);
  end;
 if STyp = 'COM' then
  begin
   {DTR, RTS und TxD(Break) mit Win-API Funktionen setzen:}
   EscapeCommFunction(ComHandle, SETDTR);
   EscapeCommFunction(ComHandle, SETRTS);
   EscapeCommFunction(ComHandle, SETBREAK);
   {Registerinhalte mit input32.dll-Funktonen einlesen und anzeigen:}
   gelesen := Inp32(BasAdr+3);
   Label3.Caption := 'Datenformat-Register';
   Label4.Caption := IntToStr(gelesen);
   gelesen := Inp32(BasAdr+4);
   Label5.Caption := 'Leitungs-Steuer-Register';
   Label6.Caption := IntToStr(gelesen);
  end;

end;

procedure TForm1.ButtonAUSClick(Sender: TObject);
begin
 if STyp = 'LPT' then
  begin
   {Alle Bits im Daten-Register lschen:}
   Out32(BasAdr, 0);  {alle Datenausgnge low}
   {Um die 4 Steuerausgnge zu setzen, mssen Bit0,
    Bit1, Bit3 gelscht und Bit2 gesetzt werden.
    Auerdem wird Bit4 (Interrupt enable) gesetzt
    und Bit5 (bidirektional) gelscht. Bit6, Bit7
    sind ohne Bedeutung:}
   Out32(BasAdr+2, 27);  {alle Steuerausgnge low}
   {Registerinhalte einlesen und anzeigen:}
   gelesen := Inp32(BasAdr);
   Label3.Caption := 'Parallelport-Daten-Register';
   Label4.Caption := IntToStr(gelesen);
   gelesen := Inp32(BasAdr+2);
   Label5.Caption := 'Parallelport-Steuer-Register';
   Label6.Caption := IntToStr(gelesen);
  end;
 if STyp = 'COM' then
  begin
   {DTR, RTS und TxD(Break) mit Win-API Funktionen setzen:}
   EscapeCommFunction(ComHandle, CLRDTR);
   EscapeCommFunction(ComHandle, CLRRTS);
   EscapeCommFunction(ComHandle, CLRBREAK);
   {Registerinhalte mit input32.dll-Funktonen einlesen und anzeigen:}
   gelesen := Inp32(BasAdr+3);
   Label3.Caption := 'Datenformat-Register';
   Label4.Caption := IntToStr(gelesen);
   gelesen := Inp32(BasAdr+4);
   Label5.Caption := 'Leitungs-Steuer-Register';
   Label6.Caption := IntToStr(gelesen);
  end;
end;

procedure TForm1.RadioLPT1Click(Sender: TObject);
begin
 STyp := 'LPT';   {parallele Schnittstelle}
 BasAdr := $378;  {Basisadresse von LPT1}
 Label3.Caption := '';
 Label4.Caption := '';
 Label5.Caption := '';
 Label6.Caption := '';
 {evtl. geffnete Schnittstelle schlieen:}
 CloseHandle(ComHandle);
 ComHandle := 0;
end;

procedure TForm1.RadioLPT1aClick(Sender: TObject);
begin
 STyp := 'LPT';   {parallele Schnittstelle}
 BasAdr := $3BC;  {alternative Basisadresse von LPT1}
 Label3.Caption := '';
 Label4.Caption := '';
 Label5.Caption := '';
 Label6.Caption := '';
 {evtl. geffnete Schnittstelle schlieen:}
 CloseHandle(ComHandle);
 ComHandle := 0;
end;

procedure TForm1.RadioLPT2Click(Sender: TObject);
begin
 STyp := 'LPT';   {parallele Schnittstelle}
 BasAdr := $278;  {Basisadresse von LPT2}
 Label3.Caption := '';
 Label4.Caption := '';
 Label5.Caption := '';
 Label6.Caption := '';
 {evtl. geffnete Schnittstelle schlieen:}
 CloseHandle(ComHandle);
 ComHandle := 0;
end;

procedure TForm1.RadioCOM1Click(Sender: TObject);
begin
 STyp := 'COM';   {serielle Schnittstelle}
 BasAdr := $3F8;  {Basisadresse von COM1}
 {evtl. geffnete Schnittstelle schlieen:}
 CloseHandle(ComHandle);
 {COM1 per API-Funktion (CreateFile) ffnen:}
 ComHandle := CreateFile('COM1', GENERIC_READ or GENERIC_WRITE,
                           0, nil, OPEN_EXISTING, 0, 0);
 {Hinweis, ob Schnittstelle geffnet werden konnte:}
 Label4.Caption := '';
 Label5.Caption := '';
 Label6.Caption := '';
 if ComHandle = INVALID_HANDLE_VALUE then
  begin
   beep;
   Label3.Caption := 'Fehler beim ffnen von COM1';
  end
  else
   Label3.Caption := 'COM1 geffnet';
end;

procedure TForm1.RadioCOM2Click(Sender: TObject);
begin
 STyp := 'COM';   {serielle Schnittstelle}
 BasAdr := $2F8;  {Basisadresse von COM2}
 {evtl. geffnete Schnittstelle schlieen:}
 CloseHandle(ComHandle);
 {COM1 per API-Funktion (CreateFile) ffnen:}
 ComHandle := CreateFile('COM2', GENERIC_READ or GENERIC_WRITE,
                           0, nil, OPEN_EXISTING, 0, 0);
 {Hinweis, ob Schnittstelle geffnet werden konnte:}
 Label4.Caption := '';
 Label5.Caption := '';
 Label6.Caption := '';
 if ComHandle = INVALID_HANDLE_VALUE then
  begin
   beep;
   Label3.Caption := 'Fehler beim ffnen von COM2';
  end
  else
   Label3.Caption := 'COM2 geffnet';
end;

procedure TForm1.ButtonInfoClick(Sender: TObject);
var MBText: PChar;
    Text: String;
begin
 Text := 'Freeware von www.FrankSteinberg.de' + CHR(10)
       + '- Quelltext inklusive' + CHR(10)
       + '- Programmiert mit Delphi 3 Professional -Vollversion-' + CHR(10)
       + '  (enthalten im Buch "Delphi fr Kids"  25,51)' + CHR(10)
       + '- Portzugriffe mit inpout32.dll -Freeware- www.logix4u.net' + CHR(10)
       + '  und ber Windows API Funktionen' + CHR(10)
       + '- Geeignet fr Win 95/98/ME/NT/2000/XP';
 MBText := PAnsiChar(Text);
 Application.Messagebox (MBText, 'PortDe 1.1  20050118', 64);
end;

procedure TForm1.ButtonHilfeClick(Sender: TObject);
begin
  ShellExecute
  (Application.MainForm.Handle, PAnsiChar('open'), PAnsiChar('PortXXX.txt'),
   nil, nil, SW_SHOWNORMAL);
end;

end.
